<?php include 'header.php';?>

<style>
.banapp {
    width: 100%;
}
.drnamebtm h4 {
    text-align: center;
    margin-top: 15px;
    margin-bottom: 4px;
    font-size: 20px;
    font-weight: 600;
}
.drnamebtm p {
    text-align: center!important;
}
.speaker-block-three .inner-box {
    height: auto;
}
.carousel-control-prev {
    left: -10%;
}
.carousel-control-next {
    right: -10%;
}
.otherfot {
    display: none;
}
.footwht {
    position: relative;
    padding: 100px 0px 220px 0px;
}
.whitefoot {
    top: -55px;
}
.blckfootpd {
    padding: 0px 0px 45px;
}
.ttm-page-title-row-inner {
    padding: 85px 0;
}



.cnttt {
      background-color: #ebebeb;
    color: #000;
    border-radius: 9px;
    /* box-shadow: 0 5px 10px 0 rgb(0, 0, 0, 0.25); */
    margin-bottom: 20px;

}

.question {
  /*font-size: 1.2rem;*/
  font-weight: 600;
  padding: 20px 80px 20px 20px;
  position: relative;
  display: flex;
  align-items: center;
  cursor: pointer;
}

.question::after {
  content: "\002B";
  font-size: 2.2rem;
  position: absolute;
  right: 20px;
  transition: 0.2s;
}

.question.active::after {
  transform: rotate(45deg);
}

.answercont {
  max-height: 0;
  overflow: hidden;
  transition: 0.3s;
}

.answer {
  padding: 0 20px 20px;
  line-height: 1.5rem;
}

.question.active + .answercont {
}

.first-div::after {
    mix-blend-mode: multiply;
    background: #5a5a5a;
}
.breadcrumb {
    margin-left: auto;
    margin-right: auto;
    display: inline-flex;
    font-weight: 400;
}
.breadcrumb {
    margin-left: auto;
    margin-right: auto;
    display: inline-flex;
    font-weight: 400;
}
.breadcrumb .breadcrumb-item a {
    z-index: 999999999999;
    position: relative;
    color: #fff;
}
.breadcrumb .breadcrumb-item {
    color: #fff;
    z-index: 999;
}
.breadcrumb .breadcrumb-item a {
    color: #fff;
}

.bulletli li {
    padding-bottom: 17px;
}

.ttm-page-title-row {
    background: url(https://htiwebs.com/holyfamily/holyfamilypages/images/Cardiovascular-1.webp);
        margin-left: auto;
    margin-right: auto;
    background-position: center !important;
    background-size: cover !important;
    background-repeat: no-repeat !important;
    background-attachment: scroll !important;
    
}
</style>


<!-- <section class="inner-banner bg-light">-->
<!--    <div class="container">-->
<!--        <div class="row align-items-center intro-title">-->
<!--            <div class="col-12">-->
<!--                <ol class="breadcrumb mb-0">-->
<!--                    <li class="breadcrumb-item"><a href="#"> <i class="fas fa-home"></i> </a></li>-->
<!--                    <li class="breadcrumb-item"> <i class="fas fa-chevron-right"></i> Heart & Vascular Sciences</li>-->
<!--                    <li class="breadcrumb-item active"> <i class="fas fa-chevron-right"></i> <span>Non-Interventional Cardiology</span></li>-->
<!--                </ol>-->
<!--            </div>-->
<!--        </div>-->
<!--    </div>-->
<!--</section>-->


<div class="ttm-page-title-row first-div">
            <div class="ttm-page-title-row-inner ttm-bgcolor-darkgrey">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-12">
                            <div class="page-title-heading">
                                 <h3 class="center hdwdth" style="z-index: 999;position: relative;color:#fff;"><span style="color:#fff;"> Cardiovascular     </span> Thoracic Surgery</h3>
                                <!--<h2 class="title">Pediatric Cardiology</h2>-->
                            </div>
                            <ol class="breadcrumb mb-0">
                                <li class="breadcrumb-item"><a href="#"> Home</a></li>
                                <li class="breadcrumb-item"> <i class="fas fa-chevron-right"></i> <a href="#"> Heart & Vascular Sciences </a></li>
                                <li class="breadcrumb-item active"> <i class="fas fa-chevron-right"></i> <span> Cardiovascular  Thoracic Surgery</span></li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>                    
        </div>



<section style="padding: 100px 0px 60px 0px;">
    <div class="container">
        <!--<div class="sec-title-style1 text-center max-width">-->
        
        
        <div class="row">
            <div class="col-md-8">
                <p>The diagnosis and treatment of disorders affecting the heart, lungs, and major blood vessels i.e systems that are crucial to life and overall health. Our thoracic and cardiovascular specialists collaborate to offer integrated heart and lung care at Holy Family Hospital, fusing precise thoracic interventions with cutting-edge cardiac expertise for total chest health.  Vascular diseases are disorders of all blood vessels, including arteries, veins, and lymphatic channels, which have important functions in the smooth circulation of blood with its nutrients throughout the body. Narrowing, blockage, or weakening of these vital vessels may bring about serious disorders such as aneurysms, peripheral artery disease, or deep vein thrombosis. The best vascular surgeons in Mumbai deliver expert care across the full spectrum of vascular disorders; thus, giving patients a renewed opportunity to lead healthier lives. </p>
            
            
            
            </div>
            <div class="col-md-4">
                <img src="images/Cardiovascular.webp" class="img100 mb-30" style="border-radius: 20px;">
            </div>
            
            
            
        
        </div>
    </div>
</section>


<section class="ptb-100 greybck">
                
            
            <div class=" container bulletli">
                <h3 class="center hdwdth animated slideInDown" data-animation="slideInDown" data-animation-delay=".5s"><span>Conditions   </span> We Treat </h3>
                <p class="supportivetext">We provide holistic care for a wide range of heart and vascular conditions, offering accurate diagnosis, advanced treatment to help patients manage their cardiac health with confidence.</p>

                <div class="mtop-4">
                <!--<div>-->
                <ul>
                    <li><b>Coronary Artery Disease (CAD):</b> CAD occurs when plaque narrows arteries supplying the heart, reducing blood flow and causing chest pain or heart attacks. Early detection, lifestyle management, and timely treatment at Holy Family Hospital help prevent long-term damage.   </li>
                    <li><b>Valvular Heart Disease: </b>Fatigue and shortness of breath can be caused by valvular heart diseases, like aortic stenosis or mitral regurgitation.Our experts provide the most appropriate diagnosis, along with advanced valve repair or replacement using both surgical and minimally invasive techniques.</li>
                    <li><b>Aortic Aneurysms and Dissections: </b>The weakening or tearing of the aorta can be life-threatening. With advanced imaging and surgical expertise, early detection and treatment of aneurysms prevent rupture and assure safe recovery. </li>
                    <li><b>Peripheral Artery Disease (PAD):</b> PAD results in poor circulation of blood to the limbs, thereby causing pain, numbness, or ulcers. Our heart specialists use interventional techniques to restore circulation & prevent complications. </li>
                    <li><b>Deep Vein Thrombosis (DVT) and Pulmonary Embolism (PE): </b>Blood clots in the veins can block the arteries in the lungs. We offer rapid diagnosis, medication, and interventional treatments to alleviate symptoms and prevent recurrence.  </li>
                    <li><b>Congenital Heart Defects: </b>Congenital structural heart defects may impact function and growth. The right course of surgical repair, device closure, and long-term monitoring will depend on the specific needs of each individual patient.  </li>
                    <li><b>Lung Cancer and Chest Tumors:</b> Tumors in the lungs or chest cavity can affect the function of your heart and lungs. Our best cardiologists and oncologists work together to coordinate safe, effective surgical and post-op care. </li>
                
                
                </ul>
                </div>
            </div>
            
            </section>
            
            
            <section id="FAQs" class="ptb-100">
            <div class="wrapper">
                <h3 class="center hdwdth animated slideInDown" data-animation="slideInDown" data-animation-delay=".5s"><span>Key   </span> Procedures</h3>
                <p class="supportivetext">Holy Family Hospital Mumbai offers a full spectrum of advanced cardiac procedures, -heart specialists combine cutting-edge technology with evidence-based protocols to ensure safe, effective, and comprehensive treatment for every patient. </p>

        <div class="container cnttt mtop-4">
            <div class="question">Coronary Artery Bypass Grafting (CABG):</div>
            <div class="answercont">
                <div class="answer">
                    The CABG, or bypass surgery of the heart, allows the restoration of blood flow through the bypassing of blocked arteries. The best cardiologists and surgeons in Mumbai work together at Holy Family Hospital, Mumbai plan, perform, and manage recoveries aimed at improving heart functionality. 
                </div>
            </div>
        </div>
  
        <div class="container cnttt">
            <div class="question">Valve Repair and Replacement </div>
            <div class="answercont">
                <div class="answer">
                    When valves are damaged, either surgical repair or replacement may be required. The best heart specialists provide open or minimally invasive procedures depending on the condition, so you recover faster with better outcomes. 
                </div>
            </div>
        </div>
        
        <div class="container cnttt">
            <div class="question">Aortic Aneurysm and Dissection Repair </div>
            <div class="answercont">
                <div class="answer">
                    Aortic weakening or tearing is an emergency that needs immediate care. Early detection and contemporary techniques, such as EVAR, help avoid rupture and ensure patient safety.  
                </div>
            </div>
        </div>
        
       
  
    </div>
        </section>


<!--start footer-->
<footer class="desk">
    <div class="auto-container" style="background: #193778;">
        <div class="container">
            <div class="row footwht">
                <div class="col-md-4">
                    <h3>Patient Care</h3>
                    <a href="#"><p>Book Appointment</p></a>
                    <a href="#"><p>Find a Doctor</p></a>
                    <a href="#"><p>Insurance & TPA</p></a>
                    <a href="#"><p>Tariff and stent Pricing</p></a>
                    <a href="#"><p>Health Check Packages</p></a>
                    <a href="#"><p>Patient Testimonials</p></a>
                    <a href="#"><p>Patient Brochure</p></a>
                    <a href="#"><p>Complaints & Feedback Form</p></a>
                    <a href="#"><p>Floor Directory</p></a>
                </div>
                <div class="col-md-4">
                    <h3>Useful Links</h3>
                    <a href="#"><p>Centers of Excellence</p></a>
                    <a href="#"><p>Corporate & Partnerships</p></a>
                    <a href="#"><p>News & Press Releases</p></a>
                    <a href="#"><p>Download Centre</p></a>
                    <a href="#"><p>Work with us</p></a>
                    <a href="#"><p>Procedures</p></a>
                    <a href="#"><p>About us</p></a>
                    <a href="#"><p>Specialities</p></a>
                </div>
                <div class="col-md-4">
                    <h3>Services</h3>
                    <a href="#"><p>Emergency & Trauma Care</p></a>
                    <a href="#"><p>OPD & IPD</p></a>
                    <a href="#"><p>Diagnostic</p></a>
                    <a href="#"><p>Pharmact(24*7)</p></a>
                    <a href="#"><p>Home Care Services</p></a>
                    <a href="#"><p>Pain Clinic</p></a>
                    <a href="#"><p>Retinal Clinic</p></a>
                    <a href="#"><p>Child & Adolescent Guidance</p></a>
                </div>
            </div>
        </div>
        <!--<img src="images/footer-img.png" class="img100 mt-30">-->
    </div>
    <div class="blackfoot">
        <div class="container">
            <div class="whitefoot">
                <div class="rg">
                    <button class="footbtn">Get appointment </button>
                    <button class="footbtn">24*7 Emergency </button>
                    <button class="footbtn">Get Direction </button>
                </div>
                <div class="row">
                    <div class="col-md-4">
                        <img src="images/logonew.webp" class="logoimg">
                    </div>
                    <div class="col-md-2"></div>
                    <div class="col-md-6">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-2">
                                        <i class="fas fa-location fafaicon"></i>
                                        <!--<img src="images/location.png">-->
                                    </div>
                                    <div class="col-md-10 pl0">
                                        <p>St Andrew’s Road,<br>Bandra (West),<br>Mumbai – 400 050. <br>Maharashtra, India.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="row mb-10">
                                    <div class="col-md-2">
                                        <i class="fa-solid fa-phone fafaicon"></i>
                                        <!--<img src="images/mail.png">-->
                                    </div>
                                    <div class="col-md-10 pl0">
                                        <p>022-62670366</p>
                                    </div>
                                </div>
                                <div class="row pt10">
                                    <div class="col-md-2">
                                        <i class="fa-solid fa-envelope fafaicon"></i>
                                        <!--<img src="images/callfoot.png">-->
                                    </div>
                                    <div class="col-md-10 pl0">
                                        <p>info@holyfamilyhospital.in</p>
                                    </div>
                                </div>
                                <div class="row fllowimg">
                                    <div class="col-md-2"></div>
                                    <div class="col-md-10 pl0 pt-10">
                                        <p><b>Follow us on</b></p>
                                        <i class="fab fa-facebook-f fafaicon"></i>
                                        <i class="fab fa-twitter fafaicon"></i>
                                        <i class="fab fa-instagram fafaicon"></i>
                                        <i class="fa-brands fa-youtube fafaicon"></i>
                                        <i class="fab fa-linkedin-in fafaicon"></i>

                                        <!--<img src="images/facebook.png">-->
                                        <!--<img src="images/twt.png">-->
                                        <!--<img src="images/insta.png">-->
                                        <!--<img src="images/yt.png">-->
                                        <!--<img src="images/ln.png">-->
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
            <div class="row blckfootpd">
                <div class="col-md-9">
                    <p>2025 Holy Family Hospital & Medical Research Center | Designed, Developed by : HashTAGit.</p>
                </div>
                <div class="col-md-3">
                    <p class="fr">Managed by : HashTAGit.</p>
                </div>
            </div>
        </div>
    </div>
</footer>

<!--footer end-->







<!--infrastructure-->
<script>
    document.addEventListener("DOMContentLoaded", function () {
  // Configuration - dynamic based on screen size
  let itemsPerSlide = window.innerWidth < 720 ? 1 : 1;
  const totalItems = document.querySelectorAll(
    ".multi-carousel-item:not(.clone)"
  ).length;
  let slideBy = 1;
  const maxCenterWidth = 700;

  // DOM elements
  const carousel = document.getElementById("multiCarousel");
  const carouselInner = document.getElementById("carouselInner");
  const prevBtn = document.getElementById("prevBtn");
  const nextBtn = document.getElementById("nextBtn");
  const carouselTitle = document.getElementById("carouselTitle");

  // Progress bar and timing variables
  const progressDuration = 10000; // 10 seconds
  let currentSlideStartTime = null;
  let pausedElapsedTime = 0;
  let autoAdvanceTimeout = null;
  let progressAnimationTimeout = null;

  // State variables
  let userHasInteracted = false;
  let isHoverPaused = false;
  let userInactivityTimeout = null;
  let isDragging = false;
  let isInitialized = false; // Flag to track initial setup
  let isFirstLoad = true; // Flag to track first load
  let currentCenterSlideNumber = -1; // Track current center slide number
  let initialLoadComplete = false; // Flag to track if initial load is complete
  let lastDirection = "none"; // Track last navigation direction

  // Function to calculate slide widths based on container width
  function calculateSlideWidths() {
    const containerWidth = carousel.offsetWidth;
    const isMobile = window.innerWidth < 720;
    if (isMobile) {
      document.documentElement.style.setProperty("--slide-width", "100%");
      return { slideWidthPercent: 100, translateOffset: 0 };
    }
    let centerWidthPercent;
    if (containerWidth <= maxCenterWidth) {
      centerWidthPercent = 75;
    } else {
      centerWidthPercent = (maxCenterWidth / containerWidth) * 100;
    }
    document.documentElement.style.setProperty(
      "--slide-width",
      `${centerWidthPercent}%`
    );
    const translateOffset = (100 - centerWidthPercent) / 2;
    return {
      slideWidthPercent: centerWidthPercent,
      translateOffset: translateOffset
    };
  }

  // Function to update configuration based on screen size
  function updateConfig() {
    itemsPerSlide = 1;
    slideBy = 1;
    return calculateSlideWidths();
  }

  // Function to reset all progress bars immediately without flicker
  function resetAllProgressBars() {
    const allProgressBars = document.querySelectorAll(".progress-bar-fill");
    allProgressBars.forEach((progressBar) => {
      progressBar.style.transition = "none";
      progressBar.style.width = "0%";
      void progressBar.offsetWidth; // Force reflow
    });
  }

  // Function to get the slide number (1, 2, 3) from an element
  function getSlideNumber(element) {
    if (!element) return -1;

    const itemNumber = element.querySelector(".item-number");
    if (itemNumber) {
      return parseInt(itemNumber.textContent, 10);
    }

    return -1;
  }

  // Function to reset all slides to default opacity
  function resetAllSlidesOpacity() {
    const allItems = document.querySelectorAll(".multi-carousel-item, .clone");
    allItems.forEach((item) => {
      // Remove any inline opacity styles that might override CSS
      item.style.opacity = "";
      item.classList.remove("center", "fade-in");
    });
  }

  // Function to update center item highlighting with fade-in effect
  function updateCenterItem() {
    const allItems = document.querySelectorAll(".multi-carousel-item, .clone");
    const centerIndex = Math.round(position);

    // Reset all slides first
    resetAllSlidesOpacity();

    if (allItems[centerIndex]) {
      const newCenterItem = allItems[centerIndex];

      // Get the slide number (1, 2, 3)
      const slideNumber = getSlideNumber(newCenterItem);

      // Add center class
      newCenterItem.classList.add("center");

      // Add fade-in effect only if:
      // 1. Initial load is complete
      // 2. This is a different slide than before
      if (initialLoadComplete && slideNumber !== currentCenterSlideNumber) {
        newCenterItem.classList.add("fade-in");

        // Remove fade-in class after animation completes
        setTimeout(() => {
          newCenterItem.classList.remove("fade-in");
        }, 600);
      }

      // Update current center slide number
      currentCenterSlideNumber = slideNumber;
    }
  }

  // Clear all timers
  function clearAllTimers() {
    if (autoAdvanceTimeout) clearTimeout(autoAdvanceTimeout);
    if (progressAnimationTimeout) clearTimeout(progressAnimationTimeout);
    if (userInactivityTimeout) clearTimeout(userInactivityTimeout);
    autoAdvanceTimeout = null;
    progressAnimationTimeout = null;
    userInactivityTimeout = null;
  }

  // Start new slide timer (always from zero)
  function startSlideTimerDelayed(delay = 150) {
    setTimeout(() => {
      startSlideTimer();
    }, delay);
  }

  function startSlideTimer() {
    if (isHoverPaused || isDragging) return;
    clearAllTimers();

    const centerItem = document.querySelector(
      ".multi-carousel-item.center, .clone.center"
    );
    if (!centerItem) return;

    const progressFill = centerItem.querySelector(".progress-bar-fill");
    if (!progressFill) return;

    // Reset bar with no transition first
    progressFill.style.transition = "none";
    progressFill.style.width = "0%";
    void progressFill.offsetWidth; // force reflow

    currentSlideStartTime = Date.now();
    pausedElapsedTime = 0;

    // Apply transition after reset
    setTimeout(() => {
      if (isHoverPaused || isDragging) return;
      progressFill.style.transition = `width ${progressDuration}ms linear`;
      progressFill.style.width = "100%";
    }, 10);

    autoAdvanceTimeout = setTimeout(() => {
      if (!isHoverPaused && !isDragging) {
        next();
      }
    }, progressDuration);
  }

  // Pause timer (for hover)
  function pauseSlideTimer() {
    if (!currentSlideStartTime || isHoverPaused) return;
    clearAllTimers();
    pausedElapsedTime = Date.now() - currentSlideStartTime;
    isHoverPaused = true;

    const centerItem = document.querySelector(
      ".multi-carousel-item.center, .clone.center"
    );
    if (centerItem) {
      const progressFill = centerItem.querySelector(".progress-bar-fill");
      if (progressFill) {
        const computedStyle = window.getComputedStyle(progressFill);
        const currentWidth = computedStyle.width;
        progressFill.style.transition = "none";
        progressFill.style.width = currentWidth;
      }
    }
  }

  // Resume timer (after hover)
  function resumeSlideTimer() {
    if (!isHoverPaused || isDragging) return;
    isHoverPaused = false;

    const centerItem = document.querySelector(
      ".multi-carousel-item.center, .clone.center"
    );
    if (centerItem) {
      const progressFill = centerItem.querySelector(".progress-bar-fill");
      if (progressFill) {
        const remainingTime = Math.max(0, progressDuration - pausedElapsedTime);
        const computedStyle = window.getComputedStyle(progressFill);
        const currentWidth = computedStyle.width;
        progressFill.style.transition = `width ${remainingTime}ms linear`;
        progressFill.style.width = "100%";

        currentSlideStartTime = Date.now() - pausedElapsedTime;
        autoAdvanceTimeout = setTimeout(() => {
          if (!isHoverPaused && !isDragging) {
            next();
          }
        }, remainingTime);
      }
    }
  }

  // Mark user interaction
  function markUserInteraction(isDragAction = false) {
    if (!isDragAction) userHasInteracted = true;
    isHoverPaused = false;
    pausedElapsedTime = 0;
    clearAllTimers();

    const centerItem = document.querySelector(
      ".multi-carousel-item.center, .clone.center"
    );
    if (centerItem) {
      const progressFill = centerItem.querySelector(".progress-bar-fill");
      if (progressFill) {
        const computedStyle = window.getComputedStyle(progressFill);
        const currentWidth = computedStyle.width;
        progressFill.style.transition = "none";
        progressFill.style.width = currentWidth;
      }
    }

    if (!isDragAction) {
      userInactivityTimeout = setTimeout(() => {
        userHasInteracted = false;
        if (!isHoverPaused && !isDragging) {
          startSlideTimer();
        }
      }, 10000);
    }
  }

  function handleDragInteraction() {
    clearAllTimers();
    const centerItem = document.querySelector(
      ".multi-carousel-item.center, .clone.center"
    );
    if (centerItem) {
      const progressFill = centerItem.querySelector(".progress-bar-fill");
      if (progressFill) {
        const computedStyle = window.getComputedStyle(progressFill);
        const currentWidth = computedStyle.width;
        progressFill.style.transition = "none";
        progressFill.style.width = currentWidth;
      }
    }
  }

  function restartProgressAfterDrag() {
    isHoverPaused = false;
    pausedElapsedTime = 0;
    currentSlideStartTime = null;
    startSlideTimerDelayed(100);
  }

  // Dynamically add clone elements for infinite loop effect
  function initializeClones() {
    const originalItems = Array.from(
      document.querySelectorAll(".multi-carousel-item:not(.clone)")
    );
    document.querySelectorAll(".clone").forEach((clone) => clone.remove());

    const clonesNeeded = 2;

    // Prepend end clones
    originalItems
      .slice(-clonesNeeded)
      .reverse()
      .forEach((item) => {
        const clone = item.cloneNode(true);
        clone.classList.add("clone");
        // Remove any inline styles that might interfere with CSS opacity
        clone.style.opacity = "";
        const progressFill = clone.querySelector(".progress-bar-fill");
        if (progressFill) {
          progressFill.style.transition = "none";
          progressFill.style.width = "0%";
        }
        carouselInner.prepend(clone);
      });

    // Append start clones
    originalItems.slice(0, clonesNeeded).forEach((item) => {
      const clone = item.cloneNode(true);
      clone.classList.add("clone");
      // Remove any inline styles that might interfere with CSS opacity
      clone.style.opacity = "";
      const progressFill = clone.querySelector(".progress-bar-fill");
      if (progressFill) {
        progressFill.style.transition = "none";
        progressFill.style.width = "0%";
      }
      carouselInner.append(clone);
    });
  }

  // Set carousel height - now uses calc to account for margins
  function setCarouselHeight() {
    // Set a CSS variable for carousel height that accounts for the margins
    document.documentElement.style.setProperty(
      "--carousel-height",
      "calc(100vh - 5rem)" // 2.5rem top + 2.5rem bottom = 5rem total
    );
  }

  // Update carousel position visually
  let slideConfig = updateConfig();
  initializeClones();
  setCarouselHeight();

  let currentIndex = 0;
  let position = 2;
  let isAnimating = false;

  // Pre-load all images to prevent flash on first slide
  function preloadImages() {
    const allImages = document.querySelectorAll(
      ".multi-carousel-item img, .clone img"
    );
    return Promise.all(
      Array.from(allImages).map((img) => {
        return new Promise((resolve) => {
          if (img.complete) {
            resolve();
          } else {
            img.onload = () => resolve();
            img.onerror = () => resolve();
          }
        });
      })
    );
  }

  function updateCarouselPosition(animate = true) {
    // If this is the first position update on page load, don't animate
    if (!isInitialized) {
      animate = false;
    }

    carouselInner.style.transition = animate ? "transform 0.5s ease" : "none";
    const { slideWidthPercent, translateOffset } = slideConfig;
    const translateX = -position * slideWidthPercent + translateOffset;
    carouselInner.style.transform = `translateX(${translateX}%)`;

    setTimeout(
      () => {
        updateCenterItem();
      },
      animate ? 50 : 0
    );
  }

  // Preload images and then initialize carousel properly
  preloadImages().then(() => {
    // Set initial position without animation
    updateCarouselPosition(false);

    // Update center item immediately
    updateCenterItem();

    // Make carousel visible after everything is positioned
    setTimeout(() => {
      carouselInner.classList.add("initialized");
      isInitialized = true;
      isFirstLoad = false;

      // After a delay, allow all slides to have fade-in effect
      setTimeout(() => {
        initialLoadComplete = true;
      }, 1000);
    }, 50);

    // Start the first timer after everything is loaded
    setTimeout(() => {
      startSlideTimer();
    }, 1000);
  });

  carouselInner.addEventListener("transitionend", function (event) {
    if (event.target !== carouselInner || event.propertyName !== "transform")
      return;
    isAnimating = false;

    const oldPosition = position;

    if (position >= totalItems + 2) {
      // When we reach the end clones, jump to the real slides without animation
      position = 2 + (position - (totalItems + 2));
      carouselInner.style.transition = "none";
      const { slideWidthPercent, translateOffset } = slideConfig;
      const translateX = -position * slideWidthPercent + translateOffset;
      carouselInner.style.transform = `translateX(${translateX}%)`;

      // Force reflow to ensure the transition is applied
      void carouselInner.offsetWidth;

      // Update center item immediately after position change
      updateCenterItem();
    } else if (position < 2) {
      // When we reach the beginning clones, jump to the real slides without animation
      position = totalItems + position;
      carouselInner.style.transition = "none";
      const { slideWidthPercent, translateOffset } = slideConfig;
      const translateX = -position * slideWidthPercent + translateOffset;
      carouselInner.style.transform = `translateX(${translateX}%)`;

      // Force reflow to ensure the transition is applied
      void carouselInner.offsetWidth;

      // Update center item immediately after position change
      updateCenterItem();
    }

    if (position !== oldPosition) {
      resetAllProgressBars();
      if (!isHoverPaused) {
        startSlideTimerDelayed(100);
      }
    } else {
      currentIndex = (position - 2 + totalItems) % totalItems;
      if (!isHoverPaused) {
        startSlideTimerDelayed(100);
      }
    }
  });

  function next() {
    if (isAnimating) return;
    isAnimating = true;
    position += slideBy;
    lastDirection = "next";
    initialLoadComplete = true; // Ensure animations are enabled after user interaction

    clearAllTimers();
    userHasInteracted = false;
    isHoverPaused = false;
    pausedElapsedTime = 0;
    currentSlideStartTime = null;

    resetAllProgressBars();
    updateCarouselPosition();
  }

  function prev() {
    if (isAnimating) return;
    isAnimating = true;
    position -= slideBy;
    lastDirection = "prev";
    initialLoadComplete = true; // Ensure animations are enabled after user interaction

    clearAllTimers();
    userHasInteracted = false;
    isHoverPaused = false;
    pausedElapsedTime = 0;
    currentSlideStartTime = null;

    resetAllProgressBars();
    updateCarouselPosition();
  }

  // Event listeners...
  nextBtn.addEventListener("click", next);
  prevBtn.addEventListener("click", prev);

  // Mouse drag functionality
  let startX = 0;
  let startPosition = 0;

  const carouselImages = document.querySelectorAll("#carouselInner img");
  carouselImages.forEach((img) => {
    img.addEventListener("dragstart", (e) => e.preventDefault());
    img.style.pointerEvents = "none";
  });

  carousel.addEventListener("mousedown", startDrag);
  carousel.addEventListener("touchstart", startDrag, { passive: true });
  carousel.addEventListener("mousemove", drag);
  carousel.addEventListener("touchmove", drag, { passive: true });
  carousel.addEventListener("mouseup", endDrag);
  carousel.addEventListener("touchend", endDrag);
  carousel.addEventListener("mouseleave", endDrag);

  function startDrag(e) {
    if (e.target.closest("button")) return;
    if (isAnimating) return;
    isDragging = true;
    startX = e.type.includes("mouse") ? e.clientX : e.touches[0].clientX;
    startPosition = position;
    carousel.classList.add("dragging");
    carouselInner.style.transition = "none";
    document.body.style.cursor = "grabbing";
    document.body.style.userSelect = "none";
    handleDragInteraction();
  }

  function drag(e) {
    if (!isDragging) return;
    const x = e.type.includes("mouse") ? e.clientX : e.touches[0].clientX;
    const walk = (x - startX) / carousel.offsetWidth;
    const { slideWidthPercent, translateOffset } = slideConfig;
    const newPosition = startPosition - walk * (100 / slideWidthPercent);
    const translateX = -newPosition * slideWidthPercent + translateOffset;
    carouselInner.style.transform = `translateX(${translateX}%)`;
  }

  function endDrag(e) {
    if (!isDragging) return;
    isDragging = false;
    carousel.classList.remove("dragging");
    document.body.style.cursor = "";
    document.body.style.userSelect = "";

    const x = e.type?.includes("mouse")
      ? e.clientX
      : e.changedTouches
      ? e.changedTouches[0].clientX
      : startX;
    const walk = (x - startX) / carousel.offsetWidth;

    if (Math.abs(walk) > 0.2) {
      initialLoadComplete = true; // Ensure animations are enabled after user interaction
      if (walk > 0) {
        lastDirection = "prev";
        prev();
      } else {
        lastDirection = "next";
        next();
      }
      setTimeout(() => {
        restartProgressAfterDrag();
      }, 600);
    } else {
      updateCarouselPosition();
      restartProgressAfterDrag();
    }
  }

  // Keyboard navigation
  document.addEventListener("keydown", function (e) {
    if (
      carousel.offsetParent === null ||
      document.activeElement.tagName === "INPUT" ||
      document.activeElement.tagName === "TEXTAREA" ||
      document.activeElement.isContentEditable
    )
      return;
    switch (e.key) {
      case "ArrowLeft":
        e.preventDefault();
        prev();
        break;
      case "ArrowRight":
        e.preventDefault();
        next();
        break;
    }
  });

  // Hover events
  carousel.addEventListener(
    "mouseenter",
    (event) => {
      const targetSlide = event.target.closest(".multi-carousel-item, .clone");
      if (
        targetSlide &&
        targetSlide.classList.contains("center") &&
        !isDragging
      ) {
        pauseSlideTimer();
      }
    },
    true
  );

  carousel.addEventListener(
    "mouseleave",
    (event) => {
      const currentCenter = document.querySelector(
        ".multi-carousel-item.center, .clone.center"
      );
      if (
        currentCenter &&
        !currentCenter.contains(event.relatedTarget) &&
        !isDragging
      ) {
        resumeSlideTimer();
      }
    },
    true
  );

  // General activity
  carousel.addEventListener("click", (e) => {
    if (!e.target.closest("button") && !isDragging) {
      markUserInteraction();
    }
  });

  carousel.addEventListener("wheel", () => {
    markUserInteraction();
  });

  // Resize handler
  window.addEventListener("resize", function () {
    slideConfig = updateConfig();
    setCarouselHeight();
    clearAllTimers();
    isHoverPaused = false;
    pausedElapsedTime = 0;
    resetAllProgressBars();
    updateCarouselPosition(false);
    markUserInteraction();
  });
});

/**
 * Script to dynamically adjust carousel height based on heading element presence
 */

class CarouselHeightAdjuster {
  constructor() {
    this.headingElement = null;
    this.carouselContainer = null;
    this.observer = null;
    this.resizeObserver = null;

    this.init();
  }

  init() {
    // Wait for DOM to be fully loaded
    if (document.readyState === "loading") {
      document.addEventListener("DOMContentLoaded", () => this.setup());
    } else {
      this.setup();
    }
  }

  setup() {
    // Locate required elements
    this.headingElement = document.querySelector(".heading");
    this.carouselContainer = document.querySelector(
      ".multi-carousel-container"
    );

    if (!this.carouselContainer) {
      console.warn("Elemento .multi-carousel-container não encontrado");
      return;
    }

    if (!this.headingElement) {
      console.warn("Elemento .heading não encontrado");
      return;
    }

    // Setup observers
    this.setupMutationObserver();
    this.setupResizeObserver();

    // Perform initial adjustment
    this.adjustCarouselHeight();

    console.log("CarouselHeightAdjuster inicializado com sucesso");
  }

  setupMutationObserver() {
    // Observer to detect changes in heading element classes
    this.observer = new MutationObserver((mutations) => {
      mutations.forEach((mutation) => {
        if (
          mutation.type === "attributes" &&
          mutation.attributeName === "class"
        ) {
          this.adjustCarouselHeight();
        }
      });
    });

    // Observe changes in heading element class attribute
    this.observer.observe(this.headingElement, {
      attributes: true,
      attributeFilter: ["class"]
    });
  }

  setupResizeObserver() {
    // Observer to detect changes in heading size (in case content changes)
    if (window.ResizeObserver) {
      this.resizeObserver = new ResizeObserver(() => {
        if (this.isHeadingVisible()) {
          this.adjustCarouselHeight();
        }
      });

      this.resizeObserver.observe(this.headingElement);
    }
  }

  isHeadingVisible() {
    if (!this.headingElement) return false;

    // Check if element is visible
    const style = window.getComputedStyle(this.headingElement);
    const hasDisplayNone = style.display === "none";
    const hasVisibilityHidden = style.visibility === "hidden";
    const hasOpacityZero = parseFloat(style.opacity) === 0;
    const hasDNoneClass = this.headingElement.classList.contains("d-none");

    return (
      !hasDisplayNone &&
      !hasVisibilityHidden &&
      !hasOpacityZero &&
      !hasDNoneClass
    );
  }

  getHeadingHeight() {
    if (!this.isHeadingVisible()) return 0;

    // Calculate total heading height including margins
    const rect = this.headingElement.getBoundingClientRect();
    const style = window.getComputedStyle(this.headingElement);

    const marginTop = parseFloat(style.marginTop) || 0;
    const marginBottom = parseFloat(style.marginBottom) || 0;

    return rect.height + marginTop + marginBottom;
  }

  adjustCarouselHeight() {
    if (!this.carouselContainer) return;

    const headingHeight = this.getHeadingHeight();
    const containerMargins = 80; // 2.5rem top + 2.5rem bottom = 80px (assuming 1rem = 16px)

    let newHeight;

    if (headingHeight > 0) {
      // If heading is visible, subtract its height + container margins
      newHeight = `calc(100vh - ${containerMargins + headingHeight}px)`;
    } else {
      // If heading is not visible, use only container margins
      newHeight = `calc(100vh - ${containerMargins}px)`;
    }

    // Apply new height
    this.carouselContainer.style.height = newHeight;

    console.log(
      `Altura do carousel ajustada para: ${newHeight} (heading ${
        headingHeight > 0 ? "visível" : "oculto"
      })`
    );
  }

  // Method to force recalculation (useful for debugging or manual use)
  recalculate() {
    this.adjustCarouselHeight();
  }

  // Method to destroy observers (cleanup)
  destroy() {
    if (this.observer) {
      this.observer.disconnect();
      this.observer = null;
    }

    if (this.resizeObserver) {
      this.resizeObserver.disconnect();
      this.resizeObserver = null;
    }

    console.log("CarouselHeightAdjuster destruído");
  }
}

// Initialize adjuster automatically
const carouselHeightAdjuster = new CarouselHeightAdjuster();

// Expose globally for manual use if needed
window.CarouselHeightAdjuster = CarouselHeightAdjuster;
window.carouselHeightAdjuster = carouselHeightAdjuster;

// Example of manual usage:
// carouselHeightAdjuster.recalculate(); // Force recalculation
// carouselHeightAdjuster.destroy(); // Remove observers

</script>

<script>
    // this function used to creat th countUp  animation for business websites
// use the three parameters to customize it 
// call it for every element
// note that may be small diffrance in the count 100 be 99 so chack it 
function numCounter(tagId,maxCount,speed){
    var initialNumber = 0;
    function counter(){
        document.getElementById(tagId).innerHTML = initialNumber;
        ++initialNumber;
    }
    var counterDelay = setInterval(counter,speed);
    function totalTime(){
        clearInterval(counterDelay);
    }
    var totalPeriod = speed * (maxCount);  
    setTimeout(totalTime, totalPeriod);
}

numCounter("Projects",83,100);
numCounter("Experienced",1250,10);
numCounter("Partners",20,10);
numCounter("Clinics",25,100);
numCounter("Happy",60000,1);

</script>






<script>
    const animatedEls = document.querySelectorAll("[data-animation]");

const observer = new IntersectionObserver((entries) => {
	entries.forEach((entry) => {
		const animation = entry.target.getAttribute("data-animation");

		if (entry.isIntersecting) {
			entry.target.classList.add("animated", `${animation}`);
		} else {
			entry.target.classList.remove("animated", `${animation}`);
		}
	});
});

animatedEls.forEach((el) => observer.observe(el));

</script>
<script>
    // interval is in milliseconds. 1000 = 1 second -> so 1000 * 10 = 10 seconds
$('.carousel').carousel({
  interval: 1000 * 10
});
</script>




<script>
    const buttonElement = document.querySelectorAll('.tablinks');
const tabContent = document.querySelectorAll(".tabcontent");

tabContent[0].style.display = "block";

buttonElement.forEach(function (i) {
    i.addEventListener('click', function (event) {

        for (let x = 0; x < buttonElement.length; x++) {
            if (event.target.id == buttonElement[x].id) {
                buttonElement[x].className = buttonElement[x].className.replace(" active", "");
                tabContent[x].style.display = "block";
                event.currentTarget.className += " active";
            } else {
                tabContent[x].style.display = "none";
                buttonElement[x].className = buttonElement[x].className.replace(" active", "");
            }
        }
        
    });
});
</script>
<script src="https://storage.ko-fi.com/cdn/scripts/overlay-widget.js"></script>

<script>
    let question = document.querySelectorAll(".question");

question.forEach(question => {
  question.addEventListener("click", event => {
    const active = document.querySelector(".question.active");
    if(active && active !== question ) {
      active.classList.toggle("active");
      active.nextElementSibling.style.maxHeight = 0;
    }
    question.classList.toggle("active");
    const answer = question.nextElementSibling;
    if(question.classList.contains("active")){
      answer.style.maxHeight = answer.scrollHeight + "px";
    } else {
      answer.style.maxHeight = 0;
    }
  })
})

</script>



<script>
    	$(function(){

		$.each($(".print-tab .print-tab-menu > li"), function(index, value){
			var menu = $(value).data('tab-menu');
			var tabID = $(value).parent().parent().data('tab-id');
			var hash = window.location.hash.split("#").join('');
			
			if(hash.length > 0){
					
				if(menu == hash){
					$('.print-tab[data-tab-id="' + tabID + '"] .print-tab-menu > li[data-tab-menu="' + menu + '"]').addClass('active');
					$('.print-tab[data-tab-id="' + tabID + '"] .print-tab-content > div[data-tab-content="' + menu + '"]').addClass('view');
				}
				
			}else{
				$('.print-tab[data-tab-id="' + tabID + '"] .print-tab-menu > li:eq(0)').addClass('active');
				$('.print-tab[data-tab-id="' + tabID + '"] .print-tab-content > div:eq(0)').addClass('view');
			}
		});
		


		$(".print-tab .print-tab-menu > li").click(function(event){
			var $this = $(this),
				$data = $this.data('tab-menu'),
				$tabID = $this.parent().parent().data('tab-id');
			if(!$(this).hasClass("active")){

				window.location.hash = $data;
				
				$('.print-tab[data-tab-id="' + $tabID + '"] .print-tab-menu > li').removeClass('active');
				$(this).addClass('active');
				
				$('.print-tab[data-tab-id="' + $tabID + '"] .print-tab-content > div.view').removeClass('view');
				$('.print-tab[data-tab-id="' + $tabID + '"] .print-tab-content > div[data-tab-content="' + $data + '"]').addClass('view');
			}
		});
	});
</script>



<script>
    const faqItems = document.querySelectorAll(".faq-item");

faqItems.forEach(item => {
  const btn = item.querySelector(".faq-question");

  btn.addEventListener("click", () => {
    // close other items
    faqItems.forEach(i => {
      if (i !== item) {
        i.classList.remove("active");
        i.querySelector(".icon").textContent = "+";
      }
    });

    // toggle current item
    item.classList.toggle("active");

    const icon = item.querySelector(".icon");
    icon.textContent = item.classList.contains("active") ? "–" : "+";
  });
});


</script>

<script>
    
$('.btnNext').click(function() {
    $('.nav-pills .active').parent().next('li').find('a').trigger('click');
});

$('.btnPrevious').click(function() {
    $('.nav-pills .active').parent().prev('li').find('a').trigger('click');
});
</script>
<script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js" integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous"></script>
  <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script>

  <script src="https://kit.fontawesome.com/1b59bc20c8.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.min.js" ></script>
<script src="js/loop.js" ></script>
</body>
</html>



